/*
 * Decompiled with CFR 0.152.
 */
package firmwareupgrade;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;

public class WindowsRegistry {
    public static final String readRegistry(String location, String key) {
        try {
            Process process = Runtime.getRuntime().exec("reg query \"" + location + "\" /v " + key);
            StreamReader reader = new StreamReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
            String output = reader.getResult();
            if (output.contains("\t")) {
                String[] parsed = output.split("\t");
                return parsed[parsed.length - 1];
            }
            if (output.contains("   ")) {
                String[] parsed = output.split("   ");
                return parsed[parsed.length - 1];
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    static class StreamReader
    extends Thread {
        private InputStream is;
        private StringWriter sw = new StringWriter();

        public StreamReader(InputStream is) {
            this.is = is;
        }

        public void run() {
            try {
                int c;
                while ((c = this.is.read()) != -1) {
                    this.sw.write(c);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getResult() {
            return this.sw.toString();
        }
    }
}

